<?php defined('MW_PATH') || exit('No direct script access allowed');

/**
 * GuestController
 * 
 * Handles the actions for guest related tasks
 * 
 * @package MailWizz EMA
 * @author Serban George Cristian <cristian.serban@mailwizz.com> 
 * @link http://www.mailwizz.com/
 * @copyright 2013-2014 MailWizz EMA (http://www.mailwizz.com)
 * @license http://www.mailwizz.com/license/
 * @since 1.0
 */
 
class UserController extends Controller
{
   // public $layout = 'sub_account';
     public function actions()
	{  
		return array(
			// captcha action renders the CAPTCHA image displayed on the contact page
			'captcha'=>array(
				'class'=>'CCaptchaAction',
				'backColor'=>0xC4DBFF,
				'foreColor'=>0xffffff,
				'height'=>32,
				'width'=>130,
				'testLimit'=>1,
				'offset'=>3
			),
			// page action renders "static" pages stored under 'protected/views/site/pages'
			// They can be accessed via: index.php?r=site/page&view=FileName
			'page'=>array(
				'class'=>'CViewAction',
			),
		);
	}
    public function  Init()
    {
		$this->layout =   Yii::app()->LayoutClass->layoutpath("fullwidth");
		$this->getData('pageStyles')->add(array('src' => Yii::app()->baseUrl."/backend/assets/css/table2.css"));
		$this->getData('pageScripts')->add(array('src' => AssetsUrl::js('reservetrip.js')));
		$this->getData('pageScripts')->add(array('src' => AssetsUrl::js('jquery.jqtransform.js')));
		$this->getData('pageStyles')->add(array('src' => AssetsUrl::css('jqtransform.css')));
	}
    /**
     * Display the login form so that a guest can login and become an administrator
     */
    public function actionSignin()
    {
		
	//	echo "SD";exit;
        $model = new UserLogin();
        $user = new ListingUsers();
        $request = Yii::app()->request;
       
      //  print_r($_POST);
        if ($request->isPostRequest && ($attributes = (array)$request->getPost($model->modelName, array()))) {
			 
			//print_r($_POST);exit;
            $model->attributes = $attributes;
            if ($model->validate()) {
			    if(Yii::app()->user->returnUrl)
			    {
				  $this->redirect(Yii::app()->user->returnUrl);
			    }
			    else
			    {
                   $this->redirect(Yii::app()->createUrl('user/my_profile'));
		        }
            }
        }
        
        $this->setData(array(
            'pageMetaTitle' => Yii::app()->name . ' | '. Yii::t('users', 'Please login'), 
            'pageHeading'   => Yii::t('users', 'Please login'),
        ));
         // echo "SDS";exit;
        $this->render(Yii::app()->LayoutClass->viewpath("login"), compact('model','user'));
       
    }
    public function actionLogin()
    {
		 
		 
        $model = new UserLogin();
        
        $request = Yii::app()->request;
      //  print_r($_POST);
        if ($request->isPostRequest && ($attributes = $_POST)) {
			 
			
            $model->attributes = $attributes;
            $model->email = $_POST['username'];
          //  print_r($model->attributes);exit;
            if ($model->validate()) {
			    if(Yii::app()->user->returnUrl)
			    {
				  $this->redirect(Yii::app()->user->returnUrl);
			    }
			    else
			    {
                   $this->redirect(Yii::app()->createUrl('user/my_profile'));
		        }
            }
            else
        {
			 Yii::app()->user->setFlash('loginfail',CHtml::errorSummary($model));
			 
			 $this->redirect(Yii::app()->createUrl('user/signin'));
			
		}
        }
        
    }
    public function actionSignup()
    {
	 
        $model = new ListingUsers();
        $request = Yii::app()->request;
        
         
        if ($request->isPostRequest  ) {
			 
			if(isset(Yii::app()->theme->name) and Yii::app()->theme->name == "styles-dubizzle")
			{
				
				  $attributes =  $_POST;
				//  $user->email = ''
				  $model->attributes = $attributes;
				  $model->con_password= $_POST['password2'];
				  $model->password= $_POST['password1'];
				  
				  if(isset($_POST['dob_year']))
				  {
					$model->dob = $_POST['dob_year'].'-'.$_POST['dob_month'].'-'.$_POST['dob_day'] ;
				   }
			}
			else
			{
				  $attributes =  (array)$request->getPost($model->modelName, array()) ;
				  $model->attributes = $attributes;
			}
            $model->status='I';
            $model->verification_code = md5(uniqid(rand(), true));
            if ($model->save()) {
				
				$emailTemplate =  CustomerEmailTemplate::model()->findByName("Registration Template");
			    if($emailTemplate)
			    {
					 $emailTemplate = $emailTemplate->content;
				}
				else
				{
					    $emailTemplate = $options->get('system.email_templates.common');
				}
				 
                $emailBody = $this->renderPartial(Yii::app()->LayoutClass->viewpath("_registration_verification"), compact('model'), true);
              
        
              
                $emailTemplate = str_replace('[CONTENT]', $emailBody, $emailTemplate);
                $logo =  '<a href="'.Yii::app()->createUrl("").'" alt="noimage"><img src="'. Yii::app()->params['uploadDir']."/logo/" .Yii::app()->options->get('system.common.logo').'" style="width:134px;height:56px;"></a> ';
                $login_path = Yii::app()->createUrl('user/signin');
                $account_path = Yii::app()->createUrl('user/my_profile');
                $emailTemplate = str_replace('{logo}',$logo, $emailTemplate);
                $emailTemplate = str_replace('{name}',$model->first_name. '  '.$model->last_name, $emailTemplate);
                $emailTemplate = str_replace('{phone}',Yii::app()->options->get('system.common.support_phone'), $emailTemplate);
                $emailTemplate = str_replace('{support}',Yii::app()->options->get('system.common.support_email'), $emailTemplate);
                $emailTemplate = str_replace('{login-path}','<a href="'.$login_path.'" style="color:#1e7ec8;" target="_blank">Login</a>', $emailTemplate);
                $emailTemplate = str_replace('{my-account}','<a href="'.$account_path.'" style="color:#1e7ec8;" target="_blank">My Account</a>', $emailTemplate);
             
                /*
                $mail = new YiiMailer();
				$mail->setFrom(Yii::app()->params['admin_email'], Yii::app()->name );
				$mail->setTo($model->email);
				$mail->setView('email');
				$mail->setSubject(Yii::app()->name .' Account created . Explore your new account ');
				$mail->setData(array('emailTemplate' => $emailTemplate));
			    $mail->send();
			    * */
			   
			    $params = array(
				'to'            =>  $model->email,
				'fromName'      =>   Yii::app()->options->get('system.common.site_name'),
				'subject'       =>	'Successfully registered with '.Yii::app()->options->get('system.common.site_name') . ', please follow the link to  verify your email address ',
				'body'          =>   $emailTemplate,
				 'mailerPlugins' => array(
                'logger'    => true,
            ),
				       
				 );
				 $mapping = DeliveryServer::getTypesMapping();
				 $server = DeliveryServer::model($mapping['smtp'])->findByPk((int)4);
				 
				 if (!$server->sendEmail($params)){
					 
					      Yii::app()->user->setFlash('registered','1');
						 
					 	  Yii::app()->user->setFlash('sendFail','Temporary error while sending your email, please try again later or contact us!');
                 
             
				 }
				 else
				 {
						 Yii::app()->user->setFlash('registered','1');
						 Yii::app()->user->setFlash('success','1');
				 }
				  
				 $this->redirect(Yii::app()->createUrl('user/signup'));
           }
           else
           {
			   	 Yii::app()->user->setFlash('registerfail',1);
		   }
           
	    }
        
        $this->setData(array(
            'pageMetaTitle' => Yii::app()->name . ' | '. Yii::t('users', 'Please login'), 
            'pageHeading'   => Yii::t('users', 'Please login'),
        ));
        
        $this->render(Yii::app()->LayoutClass->viewpath("register"), compact('model'));
    }
    public function actionRegister()
    {
		 
		 
        $model = new ListingUsers();
        $request = Yii::app()->request;
       
        if ($request->isPostRequest && ($attributes = (array)$_POST) ) {
			 
			// print_r($_POST);exit;
            $model->attributes = $attributes;
            $model->con_password= $_POST['password2'];
            $model->password= $_POST['password1'];
            
            if(isset($_POST['dob_year']))
            {
				$model->dob = $_POST['dob_year'].'-'.$_POST['dob_month'].'-'.$_POST['dob_day'] ;
			}
         //  print_r($model->attributes);exit;
             $model->status='I';
            $model->verification_code = md5(uniqid(rand(), true));
            if ($model->save()) {
				
				$emailTemplate =  CustomerEmailTemplate::model()->findByName("registration");
			    if($emailTemplate)
			    {
					 $emailTemplate = $emailTemplate->content;
				}
				else
				{
					    $emailTemplate = $options->get('system.email_templates.common');
				}
				 
                $emailBody = $this->renderPartial('_registration_verification', compact('model'), true);
                $emailTemplate = str_replace('[CONTENT]', $emailBody, $emailTemplate);
                $mail = new YiiMailer();
				$mail->setFrom(Yii::app()->params['admin_email'], Yii::app()->name );
				$mail->setTo($model->email);
				$mail->setView('email');
				$mail->setSubject(Yii::app()->name .' Account created . Explore your new account ');
				$mail->setData(array('emailTemplate' => $emailTemplate));
			    $mail->send();
				Yii::app()->user->setFlash('registered','1');
				 
                $this->redirect(Yii::app()->createUrl('user/signup'));
            }
            else
            {
				 
				 Yii::app()->user->setFlash('registerfail',CHtml::errorSummary($model));
			 
				 $this->redirect(Yii::app()->createUrl('user/signup'));
			}
            //	exit;
            
        }
        
        
    }
    public function actionLogout()
    {
        Yii::app()->user->logout();
        $this->redirect(Yii::app()->createUrl(""));    
    }
    
    /**
     * Display the form to retrieve a forgotten password.
     */
    public function actionForgot_password()
    {
		 
		Yii::import('webroot.apps.extensions.YiiMailer.YiiMailer');
		 
        $request = Yii::app()->request;
        $notify = Yii::app()->notify;
        $model = new ListingUserPasswordReset();
        
        if ($request->isPostRequest && ($attributes = (array)$request->getPost($model->modelName, array()))) {
            $model->attributes = $attributes;
            if (!$model->validate()) {
                $notify->addError(Yii::t('app', 'Please fix your form errors!'));
            } else {
				 
                $options = Yii::app()->options;
                $user = ListingUsers::model()->findByAttributes(array('email' => $model->email));
                $model->user_id = $user->user_id;
                $model->save(false);
                
                $emailTemplate = $options->get('system.email_templates.common');
                $emailBody = $this->renderPartial('_email-reset-key', compact('model', 'user'), true);
                $emailTemplate = str_replace('[CONTENT]', $emailBody, $emailTemplate);
                $mail = new YiiMailer();
               
				$mail->setFrom( Yii::app()->options->get('system.common.admin_email'), Yii::app()->options->get('system.common.site_name'));
				$mail->setTo($user->email);
				$mail->setView('forgotpassword');
				$mail->setSubject('Reset Password Link '.Yii::app()->name);
				$mail->setData(array('emailTemplate' => $emailTemplate));
				 if (!$mail->send()){
					    Yii::app()->user->setFlash('failure','Temporary error while sending your email, please try again later or contact us!');
                } else {
                         Yii::app()->user->setFlash('success','Please check your email address.');
                         $model->unsetAttributes();
                         $model->email = null;
                }

                
            }
        }
     
      

        $this->render(Yii::app()->LayoutClass->viewpath("forgot_password"), compact('model'));
    }
    public function actionForgot_password_new()
    {
		 
	 /*	Yii::import('webroot.apps.extensions.YiiMailer.YiiMailer');*/
		 
        $request = Yii::app()->request;
        $notify = Yii::app()->notify;
        $model = new ListingUserPasswordReset();
        
        if ($request->isPostRequest && ($attributes = (array)$_POST)) {
			 
            $model->attributes = $attributes;
            $model->email=@$attributes['username'];
            if (!$model->validate()) {
			 
				 Yii::app()->user->setFlash('forgotfail',CHtml::errorSummary($model));
				 $this->redirect(Yii::app()->createUrl('user/forgot_password'));
            } else {
				
				 
                $options = Yii::app()->options;
                $user = ListingUsers::model()->findByAttributes(array('email' => $model->email));
                $model->user_id = $user->user_id;
                $model->save(false);
                
                $emailTemplate = $options->get('system.email_templates.common');
                $emailBody = $this->renderPartial('_email-reset-key', compact('model', 'user'), true);
                $emailTemplate = str_replace('[CONTENT]', $emailBody, $emailTemplate);
                /*
                $mail = new YiiMailer();
				$mail->setFrom(Yii::app()->options->get('system.common.admin_email'));
				$mail->setTo($user->email);
   
				$mail->setView('forgotpassword');
				$mail->setSubject('Reset Password Link '.Yii::app()->name);
				$mail->setData(array('emailTemplate' => $emailTemplate));
				*/
				$params = array(
				'to'            => $user->email,
				'fromName'      =>   Yii::app()->options->get('system.common.site_name'),
				'subject'       =>	'Reset Password Link ' ,
				'body'          =>   $emailTemplate,
				 
				       
				);
				 $mapping = DeliveryServer::getTypesMapping();
				 $server = DeliveryServer::model($mapping['smtp'])->findByPk((int)4);
				 if (!$server->sendEmail($params)){
					 
					    Yii::app()->user->setFlash('forgotfail','Temporary error while sending your email, please try again later or contact us!');
                } else {
                         Yii::app()->user->setFlash('forgotsuccess','Please check your email address for password reset link.');
                         $model->unsetAttributes();
                         $model->email = null;
                }

                
            }
        }
     
      

        $this->render(Yii::app()->LayoutClass->viewpath("forgot_password"), compact('model'));
    }
    
    /**
     * Reached from email, will reset the password for given user and send a new one via email.
     */
    public function actionReset_password($reset_key)
    {
		 
		Yii::import('webroot.apps.extensions.YiiMailer.YiiMailer');
        $model = ListingUserPasswordReset::model()->findByAttributes(array(
            'reset_key' => $reset_key,
            'status'    => UserPasswordReset::STATUS_ACTIVE,
        ));
        
        if (empty($model)) {
            throw new CHttpException(404, Yii::t('app', 'The requested page does not exist.'));
        }
        
        $randPassword = StringHelper::random();
        $hashedPassword = Yii::app()->passwordHasher->hash($randPassword);
        
        ListingUsers::model()->updateByPk((int)$model->user_id, array('password' => $hashedPassword));
        $model->status = ListingUserPasswordReset::STATUS_USED;
        $model->save();
        
        $options = Yii::app()->options;
        $request = Yii::app()->request;
        $notify = Yii::app()->notify;
        $user = ListingUsers::model()->findByPk($model->user_id);
        $currentPassword = $user->password;
        
        
        $emailTemplate = $options->get('system.email_templates.common');
        $emailBody = $this->renderPartial('_email-new-login', compact('model', 'user', 'randPassword'), true);
        $emailTemplate = str_replace('[CONTENT]', $emailBody, $emailTemplate);
		$mail = new YiiMailer();
		$mail->setFrom(Yii::app()->params['forgot_password_mail'], Yii::app()->name);
		$mail->setTo($user->email);
		$mail->setView('resetpassword');
		$mail->setSubject(Yii::app()->name." New Password");
		$mail->setData(array('emailTemplate' => $emailTemplate));
		if (!$mail->send()){
		 
          ListingUsers::model()->updateByPk((int)$model->user_id, array('password' => $currentPassword));
          Yii::app()->user->setFlash('failure','Temporary error while sending your email containing your new login, please try again later or contact us!');
	    }
	    else
	    {
		 
			 Yii::app()->user->setFlash('success','Your new login has been successfully sent to your email address.');
		}
         
        
        $this->redirect(array('user/signin'));
    }
    public function actionMy_profile()
    {
		 
	       $this->setData(array(
            'pageMetaTitle'     =>  Yii::t('app', '{name} :: My Profile', array('{name}' => Yii::app()->name )), 
            'pageHeading'       => Yii::t('hotel_booking', 'My Profile'),
            'pageMetaDescription'   => Yii::app()->params['description'],
             
        ));
         
        $user =  new ListingUsers();
         $user =  $user->findByPk((int)Yii::app()->user->getId());
        if(Yii::app()->request->isPostRequest)
			{
				 
				  $attributes = (array)Yii::app()->request->getPost('ListingUsers', array());
				  $user->attributes =  $attributes;
				  if($user->save())
				  {
					  Yii::app()->user->setFlash('success_message2','Successfull updated your profile');
					  $this->redirect(Yii::app()->createUrl('user/my_profile'));
					  
				  }
				 
				 
			}
		
		 if (empty($user)) {
            throw new CHttpException(404, Yii::t('app', 'The requested page does not exist.'));
         }
         $this->render(Yii::app()->LayoutClass->viewpath("my_profile"),compact("user"));
	}
     public function actionMy_ads()
    {
		 
	       $this->setData(array(
            'pageMetaTitle'     =>  Yii::t('app', '{name} :: My Booking', array('{name}' => Yii::app()->name )), 
            'pageHeading'       => Yii::t('hotel_booking', 'My Booking'),
            'pageMetaDescription'   => Yii::app()->params['description'],
             
        ));
        $user =  new ListingUsers();
        $user =  $user->findByPk((int)Yii::app()->user->getId());
        if (empty($user)) {
            throw new CHttpException(404, Yii::t('app', 'The requested page does not exist.'));
         }
		if(Yii::app()->request->isPostRequest)
		{
		$search = new PlaceAnAd();
       
		if($id = Yii::app()->request->getPost("delete"))
		{
		$search=   $search->findByPk($id);
		$search->delete();

		}
		if($ids = Yii::app()->request->getPost("delete_selected"))
		{
		$search = new PlaceAnAd();
		$criteria = new CDbCriteria;
		$criteria->addInCondition('id',$ids);
		$search->deleteAll();

		}
		}
                    $criteria= new CDbCriteria;
				    $criteria->condition= "t.user_id=:uid";
				    $criteria->order="t.id desc";
				    $criteria->params[":uid"] = (int)Yii::app()->user->getId();
				    $count=PlaceAnAd::model()->count($criteria);
				    
				    $pages=new CPagination($count);
				    $pages->pageSize=10;
					$pages->applyLimit($criteria);
				    $model = PlaceAnAd::model()->findAll($criteria);
				    $categories =  Category::model()->FindCategoryies(array("condition"=>"t.user_id=:uid","params"=>array(":uid"=>Yii::app()->user->getId())));
                    
                    $this->render(Yii::app()->LayoutClass->viewpath("my_booking"),compact("user","model","pages","categories"));
	}
    public function actionMy_avatar()
    {
		 
		  
	       $this->setData(array(
            'pageMetaTitle'     =>  Yii::t('app', '{name} :: My avtar', array('{name}' => Yii::app()->name )), 
            'pageHeading'       => Yii::t('hotel_booking', 'My avtar'),
            'pageMetaDescription'   => Yii::app()->params['description'],
             
        ));
        $user =  new ListingUsers();
        $user =  $user->findByPk((int)Yii::app()->user->getId());
        if (empty($user)) {
            throw new CHttpException(404, Yii::t('app', 'The requested page does not exist.'));
         }
         if(Yii::app()->request->getPost("photo"))
         {
				$user->image = Yii::app()->request->getPost("photo");
				if($user->save())
				{
				Yii::app()->user->setFlash('success_message2',"Successfully updated your profile");
				$this->redirect(Yii::app()->createUrl("user/my_profile"));
				}
			 
		 }
         if(Yii::app()->request->isPostRequest)
         {
		 
		//Yii::import('backend.extensions.ResizeImage');
		if(isset($_FILES['photo']['tmp_name']))
		{
		
		$path =  Yii::app()->basePath . '/../../uploads' ;
		$img = rand(0,9999).'_'.time().".jpg";
		move_uploaded_file($_FILES['photo']['tmp_name'], $path."/avatar/{$img}");
		$user->image = $img;
		if($user->save())
		{
			Yii::app()->user->setFlash('success_message2',"Successfully updated your profile");
			$this->redirect(Yii::app()->createUrl("user/my_profile"));
		}
	   
	  
		}
		 }
         $avatar = Avatar::model()->allAvatars();
         $this->render(Yii::app()->LayoutClass->viewpath("my_avatar"),compact("user","avatar"));
	}
 
    public function actionAccount_settings($secion="")
    {
		  $this->getData('pageScripts')->add(array('src' => AssetsUrl::js('ui.js')));
          $this->getData('pageStyles')->add(array('src' => AssetsUrl::css('ui.css')));
		 
	       $this->setData(array(
            'pageMetaTitle'     =>  Yii::t('app', '{name} :: Account Settings', array('{name}' => Yii::app()->name )), 
            'pageHeading'       => Yii::t('hotel_booking', 'Account Settings'),
            'pageMetaDescription'   => Yii::app()->params['description'],
             
        ));
        $user =  new ListingUsers();
        $user =  $user->findByPk((int)Yii::app()->user->getId());
        if (empty($user)) {
            throw new CHttpException(404, Yii::t('app', 'The requested page does not exist.'));
         }
       
        if(Yii::app()->request->isPostRequest)
        {
			 
		
			$attributes = Yii::app()->request->getPost("ListingUsers"); 
			$user->attributes = $attributes;
		 
			if(Yii::app()->request->getPost("sitesearch")=="Change Password")
			{
				$login = new UserLogin();
				$login->email = $user->email;
				$login->password = $attributes['old_password'];
				 //LGINN VALIDATION
				if($login->validate())
				{
					$user->scenario="updatepassword";
					$user->password= $attributes['password'];
					if($user->validate("updatepassword"))
					{   
						 
						$hashedPassword = Yii::app()->passwordHasher->hash($user->password);
						ListingUsers::model()->updateByPk((int)$user->user_id, array('password' => $hashedPassword));
						Yii::app()->user->setFlash('success','Succesfully updated your password');
						$this->redirect(Yii::app()->createUrl('user/account_settings'));
					}
					else
					{
						 
						Yii::app()->user->setFlash("failure",'1');
					}
				}
				else
				{
					Yii::app()->user->setFlash("failure",'1');
					$user->addError('old_password',"Old password is incorrect");
				}
		    }
		    
		    if(Yii::app()->request->getPost("sitesearch")=="Change Name")
			{
				if($user->save())
				{
					Yii::app()->user->setFlash('success','Succesfully changed your profile');
					$this->redirect(Yii::app()->createUrl('user/account_settings'));
				}
				else
				{
					 
					Yii::app()->user->setFlash("failure",'1');
				}
			}
			 
		}
       
       
        if (empty($user)) {
            throw new CHttpException(404, Yii::t('app', 'The requested page does not exist.'));
         }
         
                   
			$user->password="";	    
          
		
		
                     $this->render(Yii::app()->LayoutClass->viewpath("account_settings"),compact("user"));
	}
    
    /**
     * The error handler
     */
    public function actionError()
    {    
        if ($error = Yii::app()->errorHandler->error) {
            if (Yii::app()->request->isAjaxRequest) {
                echo CHtml::encode($error['message']);
            } else {
                $this->setData(array(
                    'pageMetaTitle' => Yii::t('app', 'Error {code}!', array('{code}' => $error['code'])), 
                ));
                $this->render(Yii::app()->LayoutClass->viewpath("error"), $error) ;
            }    
        }
    }
     public function actionEmailVerify($verify)
    {
		$this->layout ="sub";
		Yii::import('webroot.apps.extensions.YiiMailer.YiiMailer');
        $model = ListingUsers::model()->find(array(
          "condition"=> 't.verification_code=:verify','params' => array(':verify'=>$verify),
            
        ));
        
        
        if (empty($model)) {
            throw new CHttpException(404, Yii::t('app', 'The requested page does not exist.'));
        }
				$emailTemplate =  CustomerEmailTemplate::model()->findByName("email verified");
			    if($emailTemplate)
			    {
					 $emailTemplate = $emailTemplate->content;
				}
				else
				{
					    $emailTemplate = $options->get('system.email_templates.common');
				}
				 
				 /*
                $emailBody = $this->renderPartial('_registration_verification_success', compact('model'), true);
                $emailTemplate = str_replace('[CONTENT]', $emailBody, $emailTemplate);
                $mail = new YiiMailer();
				$mail->setFrom(Yii::app()->params['admin_email'], Yii::app()->name );
				$mail->setTo($model->email);
				$mail->setView('email');
				$mail->setSubject(Yii::app()->name .' Account : Email successfully verified');
				$mail->setData(array('emailTemplate' => $emailTemplate));
			    $mail->send();
                */
                
              
                //$emailTemplate = str_replace('[CONTENT]', $emailBody, $emailTemplate);
                $logo =  '<a href="'.Yii::app()->createUrl("").'" alt="noimage"><img src="'. Yii::app()->params['uploadDir']."/logo/" .Yii::app()->options->get('system.common.logo').'" style="width:134px;height:56px;"></a> ';
                $login_path = Yii::app()->createUrl('user/signin');
                $account_path = Yii::app()->createUrl('user/my_profile');
                $emailTemplate = str_replace('{logo}',$logo, $emailTemplate);
                $emailTemplate = str_replace('{name}',$model->first_name. '  '.$model->last_name, $emailTemplate);
                $emailTemplate = str_replace('{phone}',Yii::app()->options->get('system.common.support_phone'), $emailTemplate);
                $emailTemplate = str_replace('{support}',Yii::app()->options->get('system.common.support_email'), $emailTemplate);
                $emailTemplate = str_replace('{login-path}','<a href="'.$login_path.'" style="color:#1e7ec8;" target="_blank">Login</a>', $emailTemplate);
                $emailTemplate = str_replace('{my-account}','<a href="'.$account_path.'" style="color:#1e7ec8;" target="_blank">My Account</a>', $emailTemplate);
             
			    $params = array(
				'to'            => $model->email,
				'fromName'      =>   Yii::app()->options->get('system.common.site_name'),
				'subject'       =>	'Successfully Verified your email '. Yii::app()->options->get('system.common.site_name'),
				'body'          =>   $emailTemplate,
				 );
				 $mapping = DeliveryServer::getTypesMapping();
				 $server = DeliveryServer::model($mapping['smtp'])->findByPk((int)4);
				 $server->sendEmail($params) ;exit;
        ListingUsers::model()->updateByPk($model->user_id,array("status"=>'A',"verification_code" =>  md5(uniqid(rand(), true))));
         /*
        $identity = new UserIdentity("","");
        (int)Yii::app()->user->setId($model->user_id);
       //  $identity->setId($model->user_id);
         $identity->setAutoLoginToken($model);
        */
        if ($model->validate()) {
			    Yii::app()->user->setFlash('verifySuccess','1');
                $this->redirect(Yii::app()->createUrl('user/signin'));
            }
         throw new CHttpException(404, Yii::t('app', 'The requested page does not exist.'));
    }
        public function actionMy_searches()
    {
		 if(Yii::app()->request->isPostRequest)
		 {
			$search = new Searchlist();
			
			if($id = Yii::app()->request->getPost("delete"))
			{
				 $search=   $search->findByPk($id);
				 $search->delete();
	   
			}
			if($ids = Yii::app()->request->getPost("delete_selected"))
			{
				$search = new Searchlist();
				$criteria = new CDbCriteria;
				$criteria->addInCondition('id',$ids);
				$search->deleteAll();
	   
			}
		 }
	       $this->setData(array(
            'pageMetaTitle'     =>  Yii::t('app', '{name} :: My Searches', array('{name}' => Yii::app()->name )), 
            'pageHeading'       => Yii::t('hotel_booking', 'My Searches'),
            'pageMetaDescription'   => Yii::app()->params['description'],
             
        ));
        $user =  new ListingUsers();
        $user =  $user->findByPk((int)Yii::app()->user->getId());
        if (empty($user)) {
            throw new CHttpException(404, Yii::t('app', 'The requested page does not exist.'));
         }
            $categories =  Category::model()->FindCategoryies(array("condition"=>"t.user_id=:uid","params"=>array(":uid"=>Yii::app()->user->getId())));
                  
         
           $this->render(Yii::app()->LayoutClass->viewpath("searches"),compact('categories'));
	}
    public function actionMy_watchlist()
    {
		  if(Yii::app()->request->isPostRequest)
		  {
			 $criteria = new CDbCriteria;
			 $criteria->addInCondition('id', Yii::app()->request->getPost("wl-select") );
			  Watchlist::model()->deleteAll($criteria);
			 
			  
		  }
	      $this->setData(array(
            'pageMetaTitle'     =>  Yii::t('app', '{name} :: My Watches', array('{name}' => Yii::app()->name )), 
            'pageHeading'       => Yii::t('hotel_booking', 'My Watches'),
            'pageMetaDescription'   => Yii::app()->params['description'],
             
        ));
        $user =  new ListingUsers();
        $user =  $user->findByPk((int)Yii::app()->user->getId());
        if (empty($user)) {
            throw new CHttpException(404, Yii::t('app', 'The requested page does not exist.'));
         }
       // $model=Watchlist::model()->getWtachlist(Yii::app()->user->getId());
        $categories =  Category::model()->FindCategoryies(array("condition"=>"t.user_id=:uid","params"=>array(":uid"=>Yii::app()->user->getId())));
            
        $this->render(Yii::app()->LayoutClass->viewpath("watches"),compact('categories'));
	}
	public function actionFacebooks()
	{
		
		if (!isset($_GET['login']))
        {
            $this->redirect(Yii::app()->user->returnUrl);
            return;
        }
		
		 try
        {
            Yii::import('webroot.apps.extensions.HybridAuth.HybridAuthIdentity');
            $haComp = new HybridAuthIdentity();
            if (!$haComp->validateProviderName($_GET['provider']))
                throw new CHttpException ('500', 'Invalid Action. Please try again.');
 
            $haComp->adapter = $haComp->hybridAuth->authenticate($_GET['provider']);
            $haComp->userProfile = $haComp->adapter->getUserProfile();
 
            $haComp->processLogin();  //further action based on successful login or re-direct user to the required url
        }
        catch (Exception $e)
        {
            //process error message as required or as mentioned in the HybridAuth 'Simple Sign-in script' documentation
            $this->redirect('/site/index');
            return;
        }
		// $this->render(Yii::app()->LayoutClass->viewpath("facebooks"),compact("user"));
	}
	public function actionSocialLogin()
    {
		 
		 Yii::import('root.apps.frontend.components.web.auth.HybridAuthIdentity');
      $path = Yii::getPathOfAlias('root.apps.extensions');
        require_once $path . '/hybridauth-' . HybridAuthIdentity::VERSION . '/hybridauth/Hybrid/Storage.php';  //path to the Auth php file within HybridAuth folder
 
        $path = Yii::getPathOfAlias('root.apps.extensions');
        require_once $path . '/hybridauth-' . HybridAuthIdentity::VERSION . '/hybridauth/index.php';
 
    }
    public function actionLogins()
	{
		$this->render("logins");
	}
	public function actionHoauth()
	{
		$this->render("hoauth");
	}
	public function actionProfile()
	{ 
		$this->render("profile");
	}
	  public function actionFacebook()
    {
        if (!isset($_GET['provider']))
        {
 
            $this->redirect(Yii::app()->createUrl(""));
            return;
        }
 
        try
        {
            Yii::import('root.apps.frontend.components.web.auth.HybridAuthIdentity');
            $haComp = new HybridAuthIdentity();
            if (!$haComp->validateProviderName($_GET['provider']))
                throw new CHttpException ('500', 'Invalid Action. Please try again.');
 
            $haComp->adapter = $haComp->hybridAuth->authenticate($_GET['provider']);
            $haComp->userProfile = $haComp->adapter->getUserProfile();
 
            $haComp->processLogin();  //further action based on successful login or re-direct user to the required url
        }
        catch (Exception $e)
        {
            //process error message as required or as mentioned in the HybridAuth 'Simple Sign-in script' documentation
            $this->redirect('/site/index');
            return;
        }
    }
    
      public function actionEmailalert($id=null)
    {
	 
		$this->renderPartial(Yii::app()->LayoutClass->viewpath("emailalertSuccess"),compact("id"));
	}
    public function actionEmail_subscribe($id=null)
    {
	   
	   $search = new Searchlist();
	   $search=   $search->findByPk($id);
	   
	   $search->alert =  'Y';
	   $search->save();
	   echo $search->id;
	}
    public function actionEmail_unsubscribe($id=null)
    {
	   
	   $search = new Searchlist();
	   $search=   $search->findByPk($id);
	  
	   $search->alert =  'N';
	   $search->save();
	   echo $search->id;
	}
    public function actionSavealert()
    {  
		 $search = new Searchlist();
		 $search->referal = Yii::app()->request->getQuery("url"); ;
		  
		 $search->user_id =Yii::app()->user->getId(); 
		 $search->category_id =Yii::app()->request->getQuery("category"); 
		 $search->sub_category_id =Yii::app()->request->getQuery("sub_category"); 
		 $search->country_id = Yii::app()->request->getQuery("country"); 
		 $search->state_id =Yii::app()->request->getQuery("state"); 
		 if($search->save())
		 {
			 echo $search->id;exit;
		 }
		 else
		 {
			 print_r($search->getErrors());exit;
		 }
	} 
	  public function actionEmail_subcription($id=null)
    {
	   if(!$id)
	   {
		throw new CHttpException(404, Yii::t('app', 'The requested page does not exist.'));	   
		}
	   $search = new Searchlist();
	   $search=   $search->findByPk($id);
	   $search->alert = ($search->alert ==  'Y') ? 'N' : 'Y' ;
	   
	   $search->save();
	   $this->redirect(Yii::app()->createUrl("user/my_searches"));
	}
}
